
// RS485AppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RS485App.h"
#include "RS485AppDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CRS485AppDlg dialog




CRS485AppDlg::CRS485AppDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CRS485AppDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CRS485AppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CRS485AppDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, &CRS485AppDlg::OnBnClickedButtonConnect)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, &CRS485AppDlg::OnBnClickedButtonDisconnect)
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, &CRS485AppDlg::OnBnClickedButtonUpdate)
	ON_BN_CLICKED(IDC_BUTTO_UP, &CRS485AppDlg::OnBnClickedButtoUp)
	ON_BN_CLICKED(IDC_BUTTON_LEFT, &CRS485AppDlg::OnBnClickedButtonLeft)
	ON_BN_CLICKED(IDC_BUTTON_RIGHT, &CRS485AppDlg::OnBnClickedButtonRight)
	ON_BN_CLICKED(IDC_BUTTON_DOWN, &CRS485AppDlg::OnBnClickedButtonDown)
END_MESSAGE_MAP()


// CRS485AppDlg message handlers

BOOL CRS485AppDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	HRESULT hr = CoInitialize( NULL );


	m_pDevices = NULL;	

	int res = QCAP_CREATE( "QP0203 PCI", 0, NULL, &m_pDevices, TRUE );


	GetDlgItem(IDC_EDIT_PORT_NUM)->SetWindowText(_T("0"));	

	GetDlgItem(IDC_EDIT_BUND_RATE)->SetWindowText(_T("9600"));	

	GetDlgItem(IDC_EDIT_DATA_BIT)->SetWindowText(_T("8"));	

	((CComboBox *)GetDlgItem(IDC_COMBO_PARITY_CHECK))->AddString(_T("CHECK_NONE"));
	((CComboBox *)GetDlgItem(IDC_COMBO_PARITY_CHECK))->AddString(_T("CHECK_ODD"));
	((CComboBox *)GetDlgItem(IDC_COMBO_PARITY_CHECK))->AddString(_T("CHECK_EVEN"));
	((CComboBox *)GetDlgItem(IDC_COMBO_PARITY_CHECK))->AddString(_T("CHECK_MARK"));
	((CComboBox *)GetDlgItem(IDC_COMBO_PARITY_CHECK))->AddString(_T("CHECK_SPACE"));
	((CComboBox *)GetDlgItem(IDC_COMBO_PARITY_CHECK))->SetCurSel(0);


	((CComboBox *)GetDlgItem(IDC_COMBO_STOP_BIT))->AddString(_T("STOP_BITS_ONE"));
	((CComboBox *)GetDlgItem(IDC_COMBO_STOP_BIT))->AddString(_T("STOP_BITS_ONE_POINT_FIVE"));
	((CComboBox *)GetDlgItem(IDC_COMBO_STOP_BIT))->AddString(_T("STOP_BITS_TWO"));
	((CComboBox *)GetDlgItem(IDC_COMBO_STOP_BIT))->SetCurSel(0);


	((CComboBox *)GetDlgItem(IDC_COMBO_FLOW_CONTROL))->AddString(_T("NONE"));
	((CComboBox *)GetDlgItem(IDC_COMBO_FLOW_CONTROL))->AddString(_T("CTS_RTS"));
	((CComboBox *)GetDlgItem(IDC_COMBO_FLOW_CONTROL))->AddString(_T("CTS_DTR"));
	((CComboBox *)GetDlgItem(IDC_COMBO_FLOW_CONTROL))->AddString(_T("DSR_RTS"));
	((CComboBox *)GetDlgItem(IDC_COMBO_FLOW_CONTROL))->AddString(_T("DSR_DTR"));
	((CComboBox *)GetDlgItem(IDC_COMBO_FLOW_CONTROL))->AddString(_T("XON_XOFF"));
	((CComboBox *)GetDlgItem(IDC_COMBO_FLOW_CONTROL))->SetCurSel(0);


	((CComboBox *)GetDlgItem(IDC_COMBO_ASYNC_IO))->AddString(_T("FALSE"));
	((CComboBox *)GetDlgItem(IDC_COMBO_ASYNC_IO))->AddString(_T("TRUE"));
	((CComboBox *)GetDlgItem(IDC_COMBO_ASYNC_IO))->SetCurSel(0);



	GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTO_UP )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_LEFT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_DOWN )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_RIGHT )->EnableWindow( FALSE );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CRS485AppDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRS485AppDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRS485AppDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CRS485AppDlg::OnDestroy()
{
	OnBnClickedButtonDisconnect();
	// TODO: Add your message ....handler code here
	if ( m_pDevices ) {

		QCAP_STOP( m_pDevices );

		QCAP_DESTROY( m_pDevices );

		m_pDevices = NULL;
	}

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();

}



void CRS485AppDlg::OnBnClickedButtonConnect()
{
	// TODO: Add your control notification handler code here
	CString strTemp;

	CString strOut;

	GetDlgItem(IDC_EDIT_PORT_NUM)->GetWindowText(strTemp);	

	ULONG iPortNum = _ttoi(strTemp);;

	GetDlgItem(IDC_EDIT_BUND_RATE)->GetWindowText(strTemp);	

	ULONG nBaudRate = _ttoi(strTemp);

	GetDlgItem(IDC_EDIT_DATA_BIT)->GetWindowText(strTemp);

	ULONG nDataBits = _ttoi(strTemp);


	ULONG nParityCheck = ((CComboBox *)GetDlgItem(IDC_COMBO_PARITY_CHECK))->GetCurSel();

	ULONG nStopBits = ((CComboBox *)GetDlgItem(IDC_COMBO_STOP_BIT))->GetCurSel();

    ULONG nFlowControl = ((CComboBox *)GetDlgItem(IDC_COMBO_FLOW_CONTROL))->GetCurSel();

    BOOL bAsynchronousIO = ((CComboBox *)GetDlgItem(IDC_COMBO_ASYNC_IO))->GetCurSel();

	int res;

	res = QCAP_CREATE_SERIAL_PORT( iPortNum, &m_pRS485_Port, nBaudRate, nDataBits, nParityCheck, nStopBits, nFlowControl, bAsynchronousIO);
	
	if ( res != QCAP_RS_SUCCESSFUL) {
	    strOut = " CREATE FAIL ";
		MessageBox(strOut);
		return;
	}
	
    res = QCAP_START_SERIAL_PORT( m_pRS485_Port );

	if ( res != QCAP_RS_SUCCESSFUL) {
	    strOut = " CONNECT FAIL ";
		MessageBox(strOut);
		return;
	}

	GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTO_UP )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_LEFT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_DOWN )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_RIGHT )->EnableWindow( TRUE );

}


void CRS485AppDlg::OnBnClickedButtonDisconnect()
{
	// TODO: Add your control notification handler code here
	if ( m_pRS485_Port ) {

		QCAP_STOP_SERIAL_PORT( m_pRS485_Port );

		QCAP_DESTROY_SERIAL_PORT( m_pRS485_Port );

	}

	GetDlgItem( IDC_BUTTON_CONNECT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_DISCONNECT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTO_UP )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_LEFT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_DOWN )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_RIGHT )->EnableWindow( FALSE );
}


void CRS485AppDlg::OnBnClickedButtonUpdate()
{
	// TODO: Add your control notification handler code here
	UINT pAvailablePortNum;

    QCAP_SERIAL_PORT_ENUMERATION( &pAvailablePortNum, FALSE );

	char strTemp[64];

	CString string;

	memset( strTemp, 0x00, sizeof(strTemp));

	sprintf(strTemp, "%d", pAvailablePortNum);

	string = strTemp;

	GetDlgItem(IDC_EDIT_INFO)->SetWindowText(string);	


}


void CRS485AppDlg::OnBnClickedButtoUp()
{
	// TODO: Add your control notification handler code here

	BYTE send_buffer[8];

	send_buffer[0] = 0xFF;
	send_buffer[1] = 0x01;
    send_buffer[2] = 0x00;   
    send_buffer[3] = 0x10;   
    send_buffer[4] = 0x00;   
    send_buffer[5] = 0x20;
    send_buffer[6] = 0x31;

	QCAP_SEND_SERIAL_PORT_DATA( m_pRS485_Port, send_buffer, sizeof(send_buffer) );

}


void CRS485AppDlg::OnBnClickedButtonDown()
{
	// TODO: Add your control notification handler code here
	BYTE send_buffer[8];

	send_buffer[0] = 0xFF;
	send_buffer[1] = 0x01;
    send_buffer[2] = 0x00;   
    send_buffer[3] = 0x08;   
    send_buffer[4] = 0x00;   
    send_buffer[5] = 0x20;
    send_buffer[6] = 0x29;

	QCAP_SEND_SERIAL_PORT_DATA( m_pRS485_Port, send_buffer, sizeof(send_buffer) );

}


void CRS485AppDlg::OnBnClickedButtonLeft()
{
	// TODO: Add your control notification handler code here

	BYTE send_buffer[8];

	send_buffer[0] = 0xFF;
	send_buffer[1] = 0x01;
    send_buffer[2] = 0x00;   
    send_buffer[3] = 0x04;   
    send_buffer[4] = 0x32;   
    send_buffer[5] = 0x00;
    send_buffer[6] = 0x37;

	QCAP_SEND_SERIAL_PORT_DATA( m_pRS485_Port, send_buffer, sizeof(send_buffer) );

}


void CRS485AppDlg::OnBnClickedButtonRight()
{
	// TODO: Add your control notification handler code here

	BYTE send_buffer[8];

	send_buffer[0] = 0xFF;
	send_buffer[1] = 0x01;
    send_buffer[2] = 0x00;   
    send_buffer[3] = 0x02;   
    send_buffer[4] = 0x20;   
    send_buffer[5] = 0x00;
    send_buffer[6] = 0x23;

	QCAP_SEND_SERIAL_PORT_DATA( m_pRS485_Port, send_buffer, sizeof(send_buffer) );

}


